// author: RuanShengQiang 
// date: 2017/6/21
#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw
#define PI 3.141592653589f

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

vec4 INPUT(image2d_t src_data, __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, (vec2)(tc.x, 1.0f - tc.y));
}

__kernel void MAIN(__read_only image2d_t input1, __read_only image2d_t input2, __write_only image2d_t dstImg,__global FilterParam* param)
{
	float progress = param->cur_time / param->total_time;
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[2];
	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 resolution = (float2)(W,H);
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 uv = ( fragCoord + (vec2)(0.5f) )/resolution;
	
	vec4 fragOutCol = (vec4)(1.0f);
	vec4 y = INPUT(input1, param, uv);
    vec4 y1 = INPUT(input1, param, uv);
    vec4 y2 = INPUT(input2, param, uv);
    
    vec2 centre = resolution.xy / 2.0f;
    float nT = 8.0f;
    float t = progress*4.0f;
    float dl = length(resolution);
    float l = dl / (1.5f * nT);
    float phi = t *  8.0f * PI;
    
    float mt = 1.0f - t / 100.0f;
    float R = phi * l / (2.0f * PI);
    float R_sqrt = R * R + 0.5f;
    
    if(R_sqrt < 0.0f)
    {
       fragOutCol = (vec4)(1.0f);
    }
    else
    {
    	float h_d = centre.y - (R + 0.5f);
    	h_d = max(h_d, 0.0f);
    	
    	float w_d = centre.x - (R + 0.5f);
        w_d = max(w_d, 0.0f);
        
        float tmp_1 = 255.0f * mt / R;
        float tmp_2 = 2.0f * PI / l;
        
   
        float r_sqrt = (centre.x - fragCoord.x) * (centre.x - fragCoord.x) + 
            (centre.y - fragCoord.y) * (centre.y - fragCoord.y);
            
        if(r_sqrt < R_sqrt)
        {
            float r = sqrt(r_sqrt);
            float tmpOffset = 20.0f * r * mt / R * cos(phi - tmp_2 * r);
                
            float u_alpha = tmp_1 * (1.0f - sin(phi - tmp_2 * r)) * r + 0.5f;
            u_alpha = clamp(u_alpha, 0.0f, 255.0f);
			      float alpha = 255.0f - u_alpha;
                
            vec2 newpoint;				              
            newpoint.x = (fragCoord.x + tmpOffset) / resolution.x;
            newpoint.y = (fragCoord.y + tmpOffset) / resolution.y;                                 
                                                 
            vec4 point1 = INPUT(input1, param, newpoint) ;
            vec4 point2 = INPUT(input2, param, newpoint);  
            y = mix(point1,point2, alpha / 255.0f);
         }
            
        fragOutCol = y;
    }
	
	write_imagef(dstImg, (int2)(w, textH - h -1), fragOutCol);
}